MapObjects=
{
    { id="cow_map", x=121, y=148, MinLevel=0, State="left" },
    { id="cow_map", x=95, y=169, MinLevel=0, State="right" }, 
    { id="black_cow_map", x=565, y=121, MinLevel=15, State="left" },
};




CustomMap=
{
    w = 800;
    h = 600;
};

CustomMapButton=
{
    image = "map_button",
    w = 30,
    h = 30,
    x =0,
    y =0,
};

MapButtonGaphics=
{
    "buttons/map_but.png", 
    "buttons/map_but.png", 
    "buttons/map_but.png", 
};

MapButtonStyle=
{
    parent = ButtonStyle,
    graphics = MapButtonGaphics,
};

points=
{
    {158, 112},{181, 133},{205, 151},{233, 165},{260, 174},{283, 163},
    {312, 155},{340, 156},{363, 163},{387, 174},{416, 166},{440, 153},
    {465, 143},{495, 132},{528, 125},{555, 117},{584, 114},{615, 123},
    {647, 126},{677, 118},{709, 122},{738, 136},{747, 165},{730, 187},
    {713, 211},{696, 238},{669, 254},{643, 275},{623, 298},{631, 331},
    {653, 351},{666, 378},{664, 408},{643, 425},{616, 436},{585, 442},
    {552, 451},{519, 455},{482, 463},{445, 476},{409, 489},{377, 486},
    {345, 478},{314, 470},{286, 464},{256, 460},{224, 456},{191, 452},
    {163, 443},{144, 424},{127, 402},{114, 381}
};

boundary_points = {};  --{1,13,19,22};
local ind_farm = 1;
for ind_farm = 1,4 do
    table.insert(boundary_points, gGlobalGameInfo.gFarm[ind_farm]);
end

boundary_points_image="map_button_b";
bounds_delta_x = -4;
bounds_delta_y = -4;

bonus_points_image = "map_button_bonus";
bonus_delta_x      = 0;
bonus_delta_y      = 0;  


LastLevelTrophys = CurrentLevelTrophysIndexses;
CurrentLevelTrophysIndexses = {};


backgrounds=
{
    nil,
    nil,
    nil,
    "backgrounds/map_4"    
};

function GetDefBg()
    return "backgrounds/map_1";
end
------------------------------------------------------------------------------------------
------------------------------------------------------------------------------------------
------------------------------------------------------------------------------------------
__CurrentBg = GetDefBg();
__AddBg = nil;


function GetCurrentBg()
    return __CurrentBg;    
end

function GetAddBg()
    return __AddBg;
end

function CreateAdditionalVisualObj()
    if table.getn(MapObjects)<=0 then return end;
    for i=1, table.getn(MapObjects) do

        if not MapObjects[i].State then MapObjects[i].State = ""; end
        local StartState = MapObjects[i].State;
        
        if( gGlobalPlayerInfo.gLevelNumMax >= MapObjects[i].MinLevel )then
        
            if gGlobalPlayerInfo.gLevelNumMax == MapObjects[i].MinLevel and LastLevelIsNowWinStore then
                StartState = StartState.. "_appear";
            end
            CreateVObject(MapObjects[i].id, MapObjects[i].x, MapObjects[i].y, StartState, MapObjects[i].MinLevel, MapObjects[i].State)
        end
    
    end

end


function SetCurrentBg()
    
    local current_index = 1;
    for i=1, table.getn(boundary_points) do
        if boundary_points[i] and boundary_points[i] <= gGlobalPlayerInfo.gLevelNumMax then
            current_index = i;
        else
            break;
        end
    end
    
    LastLevelIsNowWinStore = LastLevelIsNowWin;
    
    if( backgrounds[current_index] )then
        --ScriptDump("Start2");
    
    
        __CurrentBg = backgrounds[current_index];
       
        if( LastLevelIsNowWin ~= true)then            
            return;
        end;    
        --    
        
        if boundary_points[current_index] ==  gGlobalPlayerInfo.gLevelNumMax then
            local bg = GetDefBg();
            local index = current_index - 1;

            while( index > 0)do
                if(backgrounds[index])then
                    bg = backgrounds[index];
                    break;            
                end
                index = index - 1;
            end
            
            __AddBg = bg;
            
            EffectParams_ = {    
            start_aplha=255, diapason={0, 255}, 
            interval=1400, 
            work_time=1500, 
            visible_after_work=false };
        end
    end
    LastLevelIsNowWin = nil;
end


function Create()

    local map = CustomMap;
    local bpoints={}

    local count = table.getn(boundary_points);
    if( count>0)then
        for i = 1, count do 
            bpoints[ boundary_points[i] ] = i;
        end
    end

    local size_points_array = table.getn(points);
    
    for i = 1, size_points_array do --CPP_GetLastLevelNum()  do
        local custom_button = {};
        
        custom_button.image = CustomMapButton.image;
        custom_button.w = CustomMapButton.w;
        custom_button.h = CustomMapButton.h;
        
        custom_button.x = points[i][1];
        custom_button.y = points[i][2];
        custom_button.LevelNumber = i;   
        
        if( IsBonusLevel(i) )then
            custom_button.image = bonus_points_image;        
            custom_button.x = custom_button.x + bonus_delta_x;
            custom_button.y = custom_button.y + bonus_delta_y;            
        end;
        
        
        
        if( bpoints[ i ] ~= nil )then
            custom_button.image = boundary_points_image;
            custom_button.x = custom_button.x + bounds_delta_x;
            custom_button.y = custom_button.y + bounds_delta_y;
        end
        
        map[i] = ButtonMap( custom_button );
        custom_button = nil;
    end
    
    SetCurrentBg();
    
    MakeDialog
    {
        Bitmap
        {
            name="background";
            image=GetCurrentBg(),
            x=0,
            y=0,
            w = 800,
            h = 600,
        },
        Bitmap
        {
            name = "add_image";
            image=GetAddBg();
            x=0,
            y=0,
            w=800,
            h=600,            
        },
        
        
        
        GameMap(map);
        Bitmap
        { 
            name="line",
            image="backgrounds/maphint.png",
            x=178,
            y=520;
            Bitmap
            { 
                name="expert",
                image="gamepiece/map_expert.png",
                x=40,
                y=25;
            };
            Text
            {
                font = MyFont,
                name = "result_level",
                font = { standardFont, 30, BlackColor},
                x=20,y=35,w=430,h=50,
                flags = kHAlignCenter,
                label = "empty_text";
            };
        };
        
        SetStyle(MapButtonStyle),
        Button
        {
            x=40,
            y=560,
            name = "main_menu_btn",
            label="main_menu",
            close = true,   -- Just close this window
            command=
                function()
                    if(LoadLevel) then PopModal("thegame");  end
                end         
        },
--[[        
        Bitmap
        {
            name="hiscore_tooltip",
            image="backgrounds/tooltip",   
            x = 40,
            y = 380,          
            Text
            {
                font = { standardFont, 22, BlackColor},
                x=10,y=10,w=430,h=80,
                flags = kHAlignCenter,
                label = "win_hiscore";
            };            
                
        },
--]]
        
        
        FlashButton1
        {
            --  hiscore
            x=40,
            y=530,
            --tooltip="hiscore_tooltip",
            name = "hiscore_btn",
            label="hiscore_label",
            flash_delay=500;
            flash_min=32;
            flash_max=200;
            command=
                function()
                    SetFlashing("hiscore_btn", false);
                    --SetTooltip("hiscore_btn", false);                    
                
                    DoModal("scripts/hiscore.lua");
                end         
        },
      
        FlashButton1
        {
            -- trophy room
            x=650,
            y=530,
            name="trophyroom_btn",
            label="trophyroom",
            --tooltip="trophy_tooltip",
            flash_delay=500;
            flash_min=32;
            flash_max=200;
            
            command=
                function()
                    SetFlashing("trophyroom_btn", false);
                    --SetTooltip("trophyroom_btn", false);                    
                    EnableWindow("trophy_manifest",false);
                    DoModal("scripts/trophyroom.lua");
                end         
        },
        FlashButton1 --Button
        {
            x=650,
            y=560,
            name="btn_play",
            label="play",

            flash_delay=500;
            flash_min=32;
            flash_max=200;

            command=
                function()
                    LoadSelectedLevel(gGlobalPlayerInfo.gLevelNumMax);
                  
   --                 PopModal("scripts/game_map.lua");
   --                 SwapToModal("scripts/game.lua");

                end         
        },
        Bitmap
        {
            name = "trophy_manifest",
            x =230;
            image =  "panels/new_trophy";
            Text
            {
                x = 120,
                y = 35,
                w = 355,
                h = 50,
                TextAlign = kHAlignCenter,
                label = "trophy_collected",
                font = { standardFont, 30, WhiteColor},
            }
            

        },
        
    };

    CreateAdditionalVisualObj();
    
    if(EffectParams_)then         
        StartEffect( "add_image" , "alpha_blending", EffectParams_ );
    else
        EnableWindow("add_image", false);
    end    
    
    
    EnableWindow("trophy_manifest", false);
    --EnableWindow("hiscore_tooltip", false);
    --EnableWindow("trophy_tooltip", false);    
end;

function LoadSelectedLevel(current)
    
    if (current > CPP_GetLastLevelNum()) then return; end
    gGlobalPlayerInfo.gLevelNum = current;
    LevelForLoading = current;
    if(LoadLevel)then
        CloseWindow("");
        LoadLevel(LevelForLoading);
    else
        PopModal("scripts/game_map.lua");
        SwapToModal("scripts/game.lua");
    end
end



function OnBtnMouseLeave(aNumber,aBtnState)
    --EnableWindow("expert",false);
    --SetLabel("result_level","");
	OnBtnMouseMove( gGlobalPlayerInfo.gLevelNumMax-1, 1);
end

function OnBtnMouseMove(aNumber,aBtnState)
    if IsExpert(aNumber) then
        EnableWindow("expert",true);
    else
        EnableWindow("expert",false);
    end
	label = "";
	if aNumber ~= 0 then
	    local score = 0;
	    local level_info = gGlobalPlayerInfo["lev"..aNumber];
	    if (level_info ~= nil) then
	        score = level_info.score;
	    end
	    if (aBtnState == 0) then
	        label = GetString("map_hint_locked",""..aNumber);
	    else
	        label = GetString("map_hint",""..aNumber,""..score);
	    end	
	end
    SetLabel("result_level",label);
end


Create();
OnBtnMouseLeave(0,0);
if (gGlobalGameInfo.gLevelCount[1] < gGlobalPlayerInfo.gLevelNumMax) then
    EnableWindow("btn_play",false);
else
    SetFlashing("btn_play",true);
end

